// ==UserScript==
// @name         SeaArt ダブルクリックでクリップボード貼り付け＆エンター送信
// @namespace    http://tampermonkey.net/
// @version      2.2
// @description  ダブルクリックでクリップボードを貼り付け、エンターを送信する
// @author       You
// @match        https://www.seaart.ai/*
// @grant        none
// ==/UserScript==

(function() {
    'use strict';

    document.addEventListener('dblclick', async function(e) {
        const target = e.target;

        if (target.tagName === 'INPUT' || target.tagName === 'TEXTAREA' || target.isContentEditable) {
            try {
                // クリップボードの内容を取得
                const clipboardTextRaw = await navigator.clipboard.readText();

                // 空ならスキップ
                if (!clipboardTextRaw.trim()) return;

                const clipboardText = clipboardTextRaw.trim();

                // 貼り付け処理
                if (target.isContentEditable) {
                    document.execCommand('insertText', false, clipboardText);
                } else {
                    const start = target.selectionStart;
                    const end = target.selectionEnd;
                    const text = target.value;
                    target.value = text.slice(0, start) + clipboardText + text.slice(end);
                    target.selectionStart = target.selectionEnd = start + clipboardText.length;
                }

                const inputEvent = new Event('input', { bubbles: true });
                target.dispatchEvent(inputEvent);

                // 少し待ってからEnterを送信
                setTimeout(() => {
                    const enterEvent = new KeyboardEvent('keydown', {
                        bubbles: true,
                        cancelable: true,
                        key: 'Enter',
                        code: 'Enter',
                        keyCode: 13,
                        which: 13
                    });
                    target.dispatchEvent(enterEvent);

                    const enterUpEvent = new KeyboardEvent('keyup', {
                        bubbles: true,
                        cancelable: true,
                        key: 'Enter',
                        code: 'Enter',
                        keyCode: 13,
                        which: 13
                    });
                    target.dispatchEvent(enterUpEvent);
                }, 1000);
            } catch (err) {
                console.error('クリップボードの読み込みに失敗しました:', err);
            }
        }
    });
})();
